/*---------------------------------------------------------------*/
/*   Copyright (c) 1991 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffget_desc -------------------------------------------------------
  Retrieves the descriptor for the given field in the flatfile.
  The descriptor is maintained as part of the flatfile structure
  and fields are maintained in sequential order within the
  descriptor database.

  Entry Requirements:
    ffptr: A pointer to a flatfile.
    idx: The index of the column to bind to.

  Return Value:
   NULL : If the field index, the flatfile pointer, or
	      the type is invalid
   Pointer to descriptor : otherwise.

  Development History:
    Begun: 02/26/91 - Todd King
-----------------------------------------------------------------*/
#include "ffio.h"

FF_FULL_DESC *
ffget_desc (FLATFILE *ffptr, unsigned int idx)
{
   FF_FULL_DESC *dptr;
   int cnt = 0;

   if(ffptr == NULL) return(NULL);

   if(idx >= ffptr->ncols) return(NULL);

   dptr = ffptr->descdb;
   while(dptr != NULL) {
      if(cnt == idx) return(dptr);
      dptr = dptr->next;
      cnt++;
   }
   return(dptr);
}
