/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffmove_rel_rec -----------------------------------------
   Moves to a new record which is specified relative
   to the current record.  This call positions the 
   file pointer at the beginning of the record. To extract the 
   contents of the record you must make a call to ffread_rec()
   or something similar.

   Entry Requirements:
    ffptr: A flat file pointer (as returned from ffopen() )
    nrecs: A number indicating the number of records to skip.
	   A negative number skips backwords a positive number skips forward.
  
   Return Value:
     FF_SUCCESS: if the end of the flatfile is reached ,
     FF_FAILURE: if any error occurs.

  Development History:
    begun: 10/31/89 - Todd King
------------------------------------------------------------*/
#include "ffio.h"

int 
ffmove_rel_rec (FLATFILE *ffptr, long nrecs)
{
  long new_rec;

  if(ffptr == NULL) return(FF_FAILURE);

  if(!(ffptr->open_status & FF_DAT) ) {
    return(FF_FAILURE);
  }

  if(nrecs == 0) return(FF_SUCCESS);

  new_rec = ffptr->cur_recnum + nrecs;
  if(new_rec < 0) return(FF_FAILURE);

  return(ffmove_to_rec(ffptr, new_rec));
}

