/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffopen -------------------------------------------------
  Opens a flatfile for reading or writing given a filename. 
  Returns a pointer to a flatfile structure or NULL if
  unable to open the file.

  Entry Requirements:
      basename: The basename of the flatfile to open.  Can
                be a comma separated list of basenames.
      option:   either "r" for reading or "w" for writing.

  Return Value:
    A flatfile pointer, thepointer is NULL if unable to open
    the flatfile.

  Development History: (ffopen.c)
     Begun: 7/28/89 - Todd King

     Begun: 3/15/93 - Gilbert Hyatt
            Changed to now open upper and lower flatfiles.
	    Also now opens multiple files.  Basename can be
	    a comma separate list of basename.  Each of the files
	    must have the same number columns, shortnames, units
	    and width.
-------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ffio.h"

#define  UPPER_FF 1
#define  LOWER_FF 2

FLATFILE *
ffopen (char basename[], char option[])
{
  FLATFILE *ffptr;
  char     *fname;
  int      fcnt, i;

  /* Check validity of option */
  if((int) strlen(option) > 1) return(NULL);
  
  if(! (option[0] == 'w' || option[0] == 'r' || option[0] == 'a' || option[0] == 'u')) { 
    return(NULL);
  }
  
 if((ffptr = (FLATFILE *) malloc(sizeof(FLATFILE))) == NULL) return(NULL);
  memset(ffptr, 0, sizeof(FLATFILE));

  /* Added so that ffopen() can except multiple file name in for basename */
  ffptr->style = FF_STYLE_COMPONENT;
  if((fname = strdup(basename)) ==NULL) return(NULL);

  fcnt  = parse(fname, ffptr->compound.fname_list, ",", MAX_FILENAME);
  if(fcnt > 1) {
    if(option[0] != 'r') return(NULL);
    for(i = 0; i < fcnt; i++) trimspc(ffptr->compound.fname_list[i]);
    strcpy(ffptr->fname, ffptr->compound.fname_list[0]);
    ffptr->style                = FF_STYLE_COMPOUND;
    ffptr->compound.numfiles    = fcnt;
    ffptr->compound.currentfile = 0;
  } else strcpy(ffptr->fname, basename);

  /* Try opening as "upper" flatfile */
  if(ffopen_select(ffptr, option, FF_ALL) == NULL)
    if(lffopen_select(ffptr, option, FF_ALL) == NULL) /*Try opening as "lower" flatfile*/
      if(nffopen_select(ffptr, option, FF_ALL) == NULL) { /* Try opening as flowfile. */
	free(ffptr); 
	ffptr = NULL;
      }  /* end of if-if-if */

  
  return(ffptr);
}  /* end of ffopen() */

