/*---------------------------------------------------------------*/
/*   Copyright (c) 1993 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffopen_segment ----------------------------------------------------
  Opens the next segment is a compound flatfile.
  Returns FF_SUCCESS upon successful completion or FF_FAILURE
  upon error or encountering the end of file.

   Entry Requirements:
    ffptr: A flat file pointer (as returned from ffopen() )
 
  Return Value:
     FF_SUCCESS: If a record was read.
     FF_FAILURE: If the flatfile pointer is invalid or
		 if the end of file is reached.

  Development History:
    Begun: 08/30/93 - Gilbert Hyatt
---------------------------------------------------------------------*/
#include "ffio.h"

int 
ffopen_csegment (FLATFILE *ffptr)
{
   char         buffer[MAX_FILENAME + 1];
   FLATFILE     *flatfile;
   FILE         *fptr;
   FF_FULL_DESC *ffdesc1, *ffdesc2;
   int          index, good;


   if(ffptr == NULL)                     return(FF_FAILURE);
   if(ffptr->style != FF_STYLE_COMPOUND) return(FF_FAILURE);

   do {
     ffptr->compound.currentfile++;
     if(ffptr->compound.currentfile >= ffptr->compound.numfiles) return(FF_FAILURE);
     strcpy(ffptr->fname, ffptr->compound.fname_list[ffptr->compound.currentfile]);

     good = FALSE;
     if((flatfile = ffopen(ffptr->fname, "r")) != NULL) {
       good = ffcompare(ffptr, flatfile, FALSE);
     }
     
     if(good){
       fptr           = ffptr->data;
       ffptr->data    = flatfile->data;
       flatfile->data = fptr;
     }

     ffclose(flatfile);
   } while(!good);

   return(FF_SUCCESS);
}

