/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffprint_rec ---------------------------------------------------
  Prints the contents of the current buffered record to stdout
  using a standard free style format.

   Entry Requirements:
    ffptr: A flat file pointer (as returned from ffopen() )

   Return Value:
      FF_SUCCESS: If the print was successful
      FF_FAILURE: If the flatfile pointer is invalid.
  
  Development History:
    Begun: 11/2/89 - Todd King
---------------------------------------------------------------------*/
#include "ffio.h"

int 
ffprint_rec (FLATFILE *ffptr)
{
  unsigned long i;
  unsigned first = TRUE;
  FF_FULL_DESC *desc;

  if(ffptr == NULL) return(FF_FAILURE);

  for(i = 0; i < ffptr->ncols; i++) {
    if(!first) printf(", ");
    else first = FALSE;
    desc = ffget_desc(ffptr, i);
    printf("%s", desc->shortname);
  }
  printf("\n");
  for(i = 0; i < ffptr->ncols; i++) {
    printf("%s", ffget_col_str(ffptr, i));
    if(i != ffptr->ncols - 1) printf(", ");
  }
  printf("\n");
  return(FF_SUCCESS);
}

