/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffread_rec ----------------------------------------------------
  Reads the next record in to the current record buffer.
  This operation also advances the record pointer one record.
  Returns FF_SUCCESS upon successful completion or FF_FAILURE
  upon error or encountering the end of file.

   Entry Requirements:
    ffptr: A flat file pointer (as returned from ffopen() )
 
  Return Value:
     FF_SUCCESS: If a record was read.
     FF_FAILURE: If the flatfile pointer is invalid or
		 if the end of file is reached.

  Development History:
  Begun: 11/01/89 - Todd King
  Edited:09/20/93 - Gilbert Hyatt
    added support for COMPOUND files opens, that is the open of a 
    comma separated list of filenames.
---------------------------------------------------------------------*/
#include "ffio.h"

int 
ffread_rec (FLATFILE *ffptr)
{
  if(ffptr == NULL) return(FF_FAILURE);

  if(fread(ffptr->rec_buff, ffptr->reclen, 1, ffptr->data) == 0) {
    switch(ffptr->style) {
    case FF_STYLE_VIRTUAL:
      if(ffopen_segment(ffptr) == FF_FAILURE) return(FF_FAILURE);    
      else                                    return(ffread_rec(ffptr)); 
      break;
    case FF_STYLE_COMPOUND:
      if(ffopen_csegment(ffptr)== FF_FAILURE) return(FF_FAILURE);    
      else                                    return(ffread_rec(ffptr)); 
      break;
    case FF_STYLE_COMPONENT:
      return(FF_FAILURE);
    }
  }
  ffptr->cur_recnum++;
  ffdo_bind(ffptr, FF_BIND_READ);
  return(FF_SUCCESS);
}

