#include "ffio.h"
#include "sql.h"
#include <string.h>	/* For strdup() */
/*------------------------------------------------------
   Read a value from a flatfile and load it into an SQL
   scalar value.

   Entry requirements:
       ffptr: A valid pointer to a pre-opened flatfile.
       idx  : The index of a valid column in the flatfile.
       scalar : A pointer to the scalar to load the value
		in.

   Development History:
      Begun: 10/22/93 - Todd King

   Version:
      %W%   (UCLA/IGPP)   %G%
--------------------------------------------------------*/
int 
ffread_scalar (FLATFILE *ffptr, char *column, SQL_SCALAR *scalar)
{
   char *ptr;
   unsigned int idx;

   ffscol_index(ffptr, column, &idx);
   switch(ffcol_type(ffptr, idx)) {
      case FF_INT:
	 scalar->type = SQL_TYPE_INT;
	 scalar->ival = ffget_col_val(ffptr, idx);
	 break;
      case FF_FLOAT:
      case FF_DOUBLE:
	 scalar->type = SQL_TYPE_DOUBLE;
	 scalar->dval = ffget_col_val(ffptr, idx);
	 break;
      case FF_TIME:
	 scalar->type = SQL_TYPE_DATE_TIME;
	 scalar->dval = ffget_col_val(ffptr, idx);
	 break;
      case FF_ALPHA:
	 scalar->type = SQL_TYPE_TEXT;
	 ptr = ffget_col_str(ffptr, idx);
	 trimspc(ptr);
	 if(scalar->text != NULL) free(scalar->text);
	 scalar->text = strdup(ptr);
	 break;
   }
}
