/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffscol_index -------------------------------------------------

 Determines the index of the given name in the flatfile descriptor
 database. This index can be used by other flatfile calls which
 use a column's (field's) index.

  Entry Requirements:
    ffptr: A flatfile pointer.
    sname: the short column name to determine the index for.
    cidx: A variable into which the index is returned.

  Returns:
     FF_SUCCESS: If a matching column name is found.
     FF_FAILURE: If a matching short column name is not found.

  Development History:
    Begun: 11/13/89 - Todd King
-----------------------------------------------------------------*/
#include "ffio.h"

int 
ffscol_index (FLATFILE *ffptr, char sname[], unsigned int *cidx)
{
   unsigned long i;
   FF_FULL_DESC *desc;

   if(ffptr == NULL) return(FF_FAILURE);

   for(i = 0; i < ffptr->ncols; i++) {
     desc = ffget_desc(ffptr, i);
     if(strcmp(sname, desc->shortname) == 0) {
       *cidx = i;
       return(FF_SUCCESS);
     }
   }
   return(FF_FAILURE);
}

