/*---------------------------------------------------------------*/
/*   Copyright (c) 1991 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
	%W%	(UCLA, IGPP) %G%
 */
#include "ffio.h"
#include "flagdefc.h"
/*-- ffset_col_flag ------------------------------------------------
   Sets the given column to a flag value.

   Entry Requirements:
     ffptr: A pointer to a flatfile.
     idx: THe index of the column to check.

   Return Value:
    1 if successful
    If ffptr or idx is not valid 0 is returned

   Development History:
     Begun: 12/05/91 - Todd King
--------------------------------------------------------------*/
int 
ffset_col_flag (FLATFILE *ffptr, int idx)
{
  FF_FULL_DESC *desc;

  if(ffptr == NULL) return(0);
 
  if(idx >= ffptr->ncols || idx < 0) return(0);

  desc = ffget_desc(ffptr, idx);
  switch(desc->type)
  {
    case FF_INT:
	      ffset_col_val(ffptr, idx, FLAGINT);
	      break;
    case FF_FLOAT:
	      ffset_col_val(ffptr, idx, FLAGREAL);
	      break;
    case FF_DOUBLE:
    case FF_TIME:
	      ffset_col_val(ffptr, idx, FLAGDOUBLE);
	      break;
    case FF_ALPHA: 
              ffset_col_str(ffptr, idx, "?");
  }
  return (1);
}
