/*---------------------------------------------------------------*/
/*   Copyright (c) 1991 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%   (UCLA/IGPP)   %G%
*/
/*-- ffunlink -------------------------------------------------------
  Deletes (unlinks) a flatfile.

  Entry Requirements:
    name: The name for the flatfile.

  Return Value:
   0 : If unable to delete the flatfile.
   1 : If the deletion was successful.

  Development History:
    Begun: 01/16/92 - Todd King
-----------------------------------------------------------------*/
#include <sys/param.h>	/* for MAXPATHLEN  */
#include "ffio.h"

int 
ffunlink (char name[])
{
   char buffer[MAXPATHLEN + 1];
   char **ptr;

   static char *FF_extensions[] = {".DAT", ".DES", ".ABS", ".HED", NULL};

   if(!ffexists(name)) { return(0); }

   for(ptr = FF_extensions; *ptr != NULL; ptr++) {
      strncpy(buffer, name, MAXPATHLEN - 4);
      buffer[MAXPATHLEN - 4] = '\0';
      strcat(buffer, *ptr);
      if(unlink(buffer) == -1) return(0);
   }

   return(1);

}
