/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%   (UCLA/IGPP)   %G%
 */
/*-- SigMsg.c -----------------------------------------------------*/
/* Function takes in a signal number and returns a string,         */
/* that hopefully is more informative.                             */
/*                                                                 */
/* Input:                                                          */
/*    smsg: signal number.                                         */
/*                                                                 */
/* Return:                                                         */
/*    msg: Signal string if one exist, else a string that contains */
/*         the signal number.                                      */
/*                                                                 */
/* Also see:                                                       */
/*    SigMsg.h for defines for signals.                            */
/*                                                                 */
/*  Developement History:                                          */
/*    Begun: 03/16/94 - Gilbert F. Hyatt                           */
/*-----------------------------------------------------------------*/
#include <memory.h>
#include <signal.h>

#ifndef NSIG
#define NSIG 100
#endif  NSIG


char *
SigMsg (int smsg)
{
  static char  msg[30];
  static char* signalMsg[NSIG]; 
  void         Assign();

  memset(signalMsg, 0, sizeof(signalMsg));
  Assign(signalMsg);


  if (signalMsg[smsg]) return signalMsg[smsg];
  else{
    sprintf(msg, "Signal incountered: %d", smsg);
    return msg;
  }
}
  

void 
Assign (char *signalMsg[])
{
  if(signalMsg[0] != 0) return;

  signalMsg[0]          = "";

#ifdef SIGHUP
  signalMsg[SIGHUP]     = "hangup ";
#endif SIGHUP

#ifdef SIGINT
  signalMsg[SIGINT]     = "interrupt (rubout) ";
#endif SIGINT
  
#ifdef SIGQUIT
  signalMsg[SIGQUIT]    = "quit (ASCII FS) ";
#endif SIGQUIT
  
#ifdef SIGILL
  signalMsg[SIGILL]     = "illegal instruction (not reset when caught) ";
#endif SIGILL

#ifdef SIGTRAP
  signalMsg[SIGTRAP]    = "trace trap (not reset when caught) ";
#endif SIGTRAP

#ifdef SIGIOT
  signalMsg[SIGIOT]     = "IOT instruction ";
#endif SIGIOT

#ifdef SIGABRT
  signalMsg[SIGABRT]    = "used by abort, replace SIGIOT in the future ";
#endif SIGABRT

#ifdef SIGEMT
  signalMsg[SIGEMT]     = "EMT instruction ";
#endif SIGEMT
  
#ifdef SIGFPE
  signalMsg[SIGFPE]     = "floating point exception ";
#endif SIGFPE
  
#ifdef SIGKILL
  signalMsg[SIGKILL]    = "kill (cannot be caught or ignored) ";
#endif SIGKILL

#ifdef SIGBUS
  signalMsg[SIGBUS]     = "bus error ";
#endif SIGBUS

#ifdef SIGSEGV
  signalMsg[SIGSEGV]    = "segmentation violation ";
#endif SIGSEGV
  
#ifdef SIGSYS
  signalMsg[SIGSYS]     = "bad argument to system call ";
#endif SIGSYS

#ifdef SIGPIPE
  signalMsg[SIGPIPE]    = "write on a pipe with no one to read it ";
#endif SIGPIPE

#ifdef SIGALRM
  signalMsg[SIGALRM]    = "alarm clock ";
#endif SIGALRM

#ifdef SIGTERM
  signalMsg[SIGTERM]    = "software termination signal from kill ";
#endif SIGTERM

#ifdef SIGUSR1
  signalMsg[SIGUSR1]    = "user defined signal 1 ";
#endif SIGUSR1

#ifdef SIGUSR2
  signalMsg[SIGUSR2]    = "user defined signal 2 ";
#endif SIGUSR2

#ifdef SIGCLD
  signalMsg[SIGCLD]     = "child status change ";
#endif SIGCLD

#ifdef SIGCHLD
  signalMsg[SIGCHLD]    = "child status change alias (POSIX) ";
#endif SIGCHLD

#ifdef SIGPWR
  signalMsg[SIGPWR]     = "power-fail restart ";
#endif SIGPWR

#ifdef SIGWINCH
  signalMsg[SIGWINCH]   = "window size change ";
#endif SIGWINCH

#ifdef SIGURG
  signalMsg[SIGURG]     = "urgent socket condition ";
#endif SIGURG

#ifdef SIGPOLL
  signalMsg[SIGPOLL]    = "pollable event occured ";
#endif SIGPOLL

#ifdef SIGIO
  signalMsg[SIGIO]      = "socket I/O possible (SIGPOLL alias) ";
#endif SIGIO

#ifdef SIGSTOP
  signalMsg[SIGSTOP]    = "stop (cannot be caught or ignored) ";
#endif SIGSTOP

#ifdef SIGTSTP
  signalMsg[SIGTSTP]    = "user stop requested from tty ";
#endif SIGTSTP

#ifdef SIGCONT
  signalMsg[SIGCONT]    = "stopped process has been continued ";
#endif SIGCONT

#ifdef SIGTTIN
  signalMsg[SIGTTIN]    = "background tty read attempted ";
#endif SIGTTIN

#ifdef SIGTTOU
  signalMsg[SIGTTOU]    = "background tty write attempted ";
#endif SIGTTOU

#ifdef SIGVTALRM
  signalMsg[SIGVTALRM]  = "virtual timer expired ";
#endif SIGVTALRM

#ifdef SIGPROF
  signalMsg[SIGPROF]    = "profiling timer expired ";
#endif SIGPROF

#ifdef SIGXCPU
  signalMsg[SIGXCPU]    = "exceeded cpu limit ";
#endif SIGXCPU

#ifdef SIGXFSZ
  signalMsg[SIGXFSZ]    = "exceeded file size limit ";
#endif SIGXFSZ

#ifdef SIGWAITING
  signalMsg[SIGWAITING] = "process's lwps are blocked ";
#endif SIGWAITING

#ifdef SIGLWP
  signalMsg[SIGLWP]     = "special signal used by thread library ";
#endif SIGLWP

#ifdef SIGFREEZE
  signalMsg[SIGFREEZE]  = "special signal used by CPR ";
#endif SIGFREEZE

#ifdef SIGTHAW
  signalMsg[SIGTHAW]    = "special signal used by CPR ";
#endif SIGTHAW

  
  /* insert new signals here, and move _SIGRTM* appropriately */
#ifdef _SIGRTMIN
  signalMsg[_SIGRTMIN]  = "first (highest-priority) realtime signal ";
#endif _SIGRTMIN

#ifdef _SIGRTMAX
  signalMsg[_SIGRTMAX]  = "last (lowest-priority) realtime signal ";
#endif _SIGRTMAX

}
