/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%   (UCLA/IGPP)   %G%
 */
/*-- COPYLIST -----------------------------------------------------*/
/* Makes a copy of a list of string variables. Allocates memory    */
/* dynamically for the storage of the copy.                        */
/*                                                                 */
/* Returns:                                                        */
/*   A pointer to the allocated list, or a pointer to a null list  */
/*   if it were unable to allocate enough memory.                  */
/*                                                                 */
/*  Entry Requirements:                                            */
/*   cnt: The number of entries in the list                        */
/*   list: the list of pointer to the strings to copy.             */
/*                                                                 */
/*  Developement History:                                          */
/*    Begun: 03/02/87 - Todd King                                  */
/*                   Under GG44 support                            */
/*-----------------------------------------------------------------*/
char **
copylist (int cnt, char *list[])
{
  char **listptr;
  char **nulllist = (char **)0;
  char *nullstr = (char *)0;

  listptr = (char **)malloc((cnt + 1) * sizeof(char **));
  if ( listptr == nulllist) return(listptr);
  while(--cnt >= 0)
  {
    listptr[cnt] = (char *)malloc(strlen(list[cnt]) + 1);
    if(listptr[cnt] == nullstr) return(nulllist);
    else strcpy(listptr[cnt], list[cnt]);
  }
  return(listptr);
}

