/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%   (UCLA/IGPP)   %G%
 */
/*-- SETMASK ------------------------------------------------------*/
/* sets the value of the global variables for use by the high      */
/* level mask matching calls. Expands home directory short hand    */
/* into the full path (i.e. ~bogus => /usr/bogus or whatever is    */
/* bogus' home directory).                                         */
/*                                                                 */
/*  Returns:                                                       */
/*    -1: Unknown user in home directory short hand (~name)        */
/*     0: All went well.                                           */
/*                                                                 */
/*  Entry Requirements:                                            */
/*    mask: the mask to set the varaibles to.                      */
/*                                                                 */
/*  Developement History:                                          */
/*    Begun: 02/24/87 - Todd King                                  */
/*                   Under GG44 support                            */
/*-----------------------------------------------------------------*/
#include "lowmask.h"

int 
setmask (char *mask)
{
  extern struct filemask Fmask;

  char hdir[256];
  char *part[2];
  int ret;

  strcpy(Fmask.fullmask, mask);
  ret = parse(mask,part,"/",2);

/* Convert Home directory short hand */
  if(part[0][0] == '~') 
  {
    if (home_dir(part[0]+1, hdir) < 0) return(-1);
    else 
    {
      strcpy(Fmask.fullmask, hdir);
      if(ret > 1) 	/* replace '/' and appended string */
      {
        strcat(Fmask.fullmask,"/");
        strcat(Fmask.fullmask, part[1]);
      }
    }
  }
  return(0);
}

