
/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
   %W%   (UCLA/IGPP)   %G%
*/
/* -- STRIP_PATH ------------------------------------------- */
/*   Strips the path name leaving only the file name         */
/*							     */
/* ENTRY REQUIREMENTS:                                       */
/*    PATHNAME: a string which contains the the path and     */
/*       filename.					     */
/*                                                           */
/* RETURN VALUES:                                            */
/*    returns a pointer to PATHNAME                          */
/*    PATHNAME is modified to contain just the file name.    */
/*                                                           */
/* Development History:                                      */
/*   Begun:  7/15/88 - Scott Bendar                          */
/*             Under ???? support.                           */
/* --------------------------------------------------------- */

#include <stdio.h>

char *
strip_path (char *pathname)
{
  char *begin, *last;
  char *strrchr();

  begin = pathname;
  if ((last = strrchr(pathname,'/')) != NULL) {    /* check for path  */
     last++;     /* to skip the / mark */

     while ( *last != '\0') 
       *(pathname++) = *(last++);    /* copy the string */

     *pathname = '\0';

  }

  return begin;       /* sucessful completion */
}
