/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/* -- COLPARSE ------------------------------------------------*/
/*                                                             */
/* ENTRY REQUIREMENTS:                                         */
/*   COLSTRING:  A string to parse into an array of column     */
/*               names.  The string is a list of patterns      */
/*               or column names.  For example: "by,by,bz",    */
/*               or "b*" or "b[xyz], e?".                      */
/*   COLARRAY:  An array of character pointers to place the    */
/*              names of the matching columns in.              */
/*   MAXARRAY:  The maximum number of elements in COLARRAY.    */
/*   DUPLICATES_ALLOWED:  If it is TRUE the same column name   */
/*                        will be allowed to be in the array   */
/*                        more that once.                      */
/*                                                             */
/* RETURN VALUES:                                              */
/*   The number of columns which match any of the patterns     */
/*   or -1 for an error.                                       */
/*                                                             */
/* NOTES:                                                      */
/*   Destroys COLSTRING, but dynamically allocates making      */
/*     COLSTRING reusable.                                     */
/*                                                             */
/*   Uses parserc, pipec and miscc libraries.                  */
/*                                                             */
/*      Development History:                                   */
/*              Begun:  4/24/87 - Marco Zagha                  */
/*                  Under GG44 support.                        */
/*                                                             */
/*  Version:                                                   */
/*     %W%      (UCLA/IGPP)     %G%                            */
/* ------------------------------------------------------------*/
int 
colparse (char colstring[], char *colarray[], int maxarray, int duplicates_allowed)
{
#include <stdio.h>
#ifndef VMS             /* we don't need this for VMS */
#include <string.h>	/* for strdup() */
#endif
#include "stddescc.h"
#include "maxpipec.h"

  int dnum, i, nparts, matchcount;
  char tempname[9];
  int colmatch[MAXCOLS];
  char *colparts[MAXCOLS];

  extern DESC Desc[];
  extern int Ndesc;

/* Presets   */
  matchcount = 0;
  for (i=0; i < MAXCOLS; i++)
    colmatch[i] = 0;
  
  nparts = parse(colstring, colparts, ",", MAXCOLS);
  for (i = 0; (i < nparts) && (matchcount < maxarray); i++)
    for (dnum = 0; dnum < Ndesc; dnum++)
    {
      strcpy(tempname, Desc[dnum].shortcol);
      trimspc(tempname);  /* because strings in database are padded   */
      if (ismatch(tempname, colparts[i]))
      {
	if (duplicates_allowed || (colmatch[dnum] == 0))
	{
	  colmatch[dnum] = 1;
	  colarray[matchcount] = strdup(tempname);
          if (colarray[matchcount] == NULL) return (-1);
	  matchcount++;
	  if (matchcount >= maxarray) break;
	}
      }
    }
  return(matchcount);
}
