/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-- KW_MATCH -----------------------------*/
/* Searches a list of possible key words   */
/* to see if a given word matches any of   */
/* them. The list of possible keywords must*/
/* be terminated by a zero length keyword. */
/* If the given word is a unique           */
/* fration of any keyword then the index   */
/* of the key word in the list if returned */
/* if the word is ambiguous -2 is returned */
/* if the word is not found -1 is returned */
/*                                         */
/* Development History:                    */
/*   Begun: 11/25/85 - Todd King           */
/*          Under GH06 support.            */
/*                                         */
/*  Version:                               */
/*     %W%      (UCLA/IGPP)     %G%        */
/*-----------------------------------------*/
 
int 
kw_match (char word[], char *possible[])
{
  int j,n,end,match;
  unsigned int g_flag,c_flag;
 
  end=strlen(word);  /* Presets */
  j=0;
  match=(-1);
  g_flag=0;
  j=0;
  while(strlen(possible[j])!=0 && match!=-2) /* stop if ambig. or end of list */  {
    n=0;
    while(n<end && word[n] == possible[j][n]) n++;  /* compare strings */
    if (n==end)  /* complete match */
    {
      if(g_flag) match=(-2);
      else
      { match=j;
        g_flag=1;
      }  
    }  
    j++;              /* Point to next word */
  }
  return(match);
}

