/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/

/* -- PAD_STR ---------------------------------------------- */
/* Pads the string with spaces to the given length.          */
/*                                                           */
/* ENTRY REQUIREMENTS:                                       */
/*   STR: the string to pad.                                 */
/*   N:   number of characters to pad to.                    */
/*                                                           */
/* RETURN VALUES:                                            */
/*   1 if any padding done; 0 otherwise.                     */
/*                                                           */
/* Development History:                                      */
/*    Begun:  3/30/87 - Marco Zagha                          */
/*       Under GG44 support.                                 */
/*                                                           */
/*  Version:                                                 */
/*     %W%      (UCLA/IGPP)     %G%                          */
/* --------------------------------------------------------- */
int 
pad_str (char str[], int n)
{
  int j, len;

  if (n < 0) return (-1);
  if ((len = strlen(str)) < n)
   {
    for (j = len; j < n; j++)
      str[j] = ' ';
    str[n] = '\0';
    return (1);
   }
  else 
    return (0);
}
