
/*----------------------------------------------------------------
   Dumps a token list produced by pattern_parse().
   Useful for debugging purposes.

   Entry Requirements:
      pattern : A token list defining the pattern to compare
		the string to. Produced by pattern_parse().

   Return Value:
      none.
      
   Development History:
      Begun: 03/02/92 - Todd King

   Version:
      %W%    (UCLA/IGPP)   %G%
------------------------------------------------------------------*/
#include "pattern.h"
void 
pattern_dump (PATTERN *pattern)
{
   PATTERN *p;

   for(p = pattern; p != NULL; p = p->next) {
      switch(p->type) {
	 case PATTERN_TYPE_SINGLE_CHAR:
	    printf("Single Char\n");
	    break;
	 case PATTERN_TYPE_MULTIPLE_CHAR:
	    printf("Mulitple Char\n");
	    break;
	 case PATTERN_TYPE_FIXED:
	    printf("String: \"%s\"\n", p->text);
	    break;
	 default:
	    printf("Unknown type: %d\n", p->type);
	    break;
      }
   }
}

