
/*----------------------------------------------------------------
   Frees all memory associated with a PATTERN link list.

   Entry Requirements:
      none.

   Return Value:
      none

   Development History:
      Begun: 03/05/92 - Todd King

   Version:
      %W%      (UCLA/IGPP)    %G%
------------------------------------------------------------------*/
#include "pattern.h"

void 
pattern_free (PATTERN *pattern)
{
   PATTERN *p;
   PATTERN *next;

   if(pattern == NULL) return;

   for(p = pattern; p != NULL; p = next) {
     next = p->next;
     switch(p->type) {
        case PATTERN_TYPE_FIXED:
           if(p->text != NULL) free(p->text);
           break;
     }
     free(p);
   }
   return;
}
