/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/

/* -- STRIPNL ---------------------------------------------- */
/*  Strips a newline of the end of a character string.       */
/*  Useful after using fgets to read a line.                 */
/*                                                           */
/* ENTRY REQUIREMENTS:                                       */
/*   A character string ending with \n.                      */
/*                                                           */
/* RETURN VALUES:                                            */
/*   1 if a newline was present; 0 otherwise.                */
/*                                                           */
/*      Development History:                                 */
/*              Begun:  12/4/86 - Marco Zagha                */
/*                 Under GG44 support.                       */
/*                                                           */
/*  Version:                                                 */
/*     %W%      (UCLA/IGPP)     %G%                          */
/* --------------------------------------------------------- */
int 
stripnl (char str[])
{
  int len;

  len = strlen(str);
  if (len == 0) return(0);
  if (str[len-1] == '\n')
    {
      str[len-1]='\0';
      return(1);
    }
  else
    return(0);
}
