/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/

/* -- STRIP_COMMENT ---------------------------------------- */
/*                                                           */
/* ENTRY REQUIREMENTS:                                       */
/*   LINE:  the string to strip any comments from.           */
/*   COMMENT_STR:  the comment indicator (e.g. "/*").        */
/*   BEGINNING_OF_LINE:  whether or not the comment          */
/*                       indicator must be at the beginning  */
/*                       of a line.                          */
/*                                                           */
/* RETURN VALUES:                                            */
/*   1 if a comment was stripped; 0 otherwise.               */
/*                                                           */
/*      Development History:                                 */
/*              Begun:  3/30/87 - Marco Zagha                */
/*                    Under GG44 support.                    */
/*                                                           */
/*  Version:                                                 */
/*     %W%      (UCLA/IGPP)     %G%                          */
/* --------------------------------------------------------- */
int 
strip_comment (char line[], char comment_str[], int beginning_of_line)
{
  int index;
  int comment_length = strlen(comment_str);

  if (beginning_of_line)
  {
    if (!strncmp(comment_str, line, comment_length))
      {
        strcpy(line, "");
	return(1);
      }
    else
      return (0);
  }
  else
  {
    if ((index = findstr(comment_str, line, '"')) < 0)
      return (0);
    else
      {
	line[index] = '\0';
        return (1);
      }
  }
}
