/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-- TRIMSPC --------------------------------------*/
/* trims leading and trailing spaces from          */
/* a passed string.                                */
/* Considers tabs, space, newline, carriage return */
/* and formfeeds to be white space (per 'isspace') */
/*                                                 */
/*  Begun:  11/21/85 - Todd King                   */
/*               Under GH06 support.               */
/*  Revised: 1/29/87 - Todd King                   */
/*               to also trim tabs, et al:         */
/*               Under GH06 support.               */
/*  Edited: 04/27/94 - Gilbert Hyatt               */
/*               added check for NULL and equal    */
/*               length strings.                   */
/*                                                 */
/*  Version:                                       */
/*     %W%      (UCLA/IGPP)     %G%                */
/*-------------------------------------------------*/
#include <ctype.h>

#ifndef NULL
#define NULL    0
#endif
 
int 
trimspc (char *string)
{
 int j,n,end;

  if(string  == NULL) return(1);
  if(*string == '\0') return(1);

  j=strlen(string)-1;  /* First xter in string */
  while(isspace(string[j]) && j > 0) j--;  /* trim trailing spaces */
  string[j+1]='\0'; /* truncate */
  j=0;  /* preset */
  while(isspace(string[j]) && string[j] != '\0') j++; /* trim leading spaces */
  if(j>0)  /* shift string left */
  {
    end=strlen(string);
    for(n=0;n<end;n++) string[n]=string[j+n];
  }
  return(0);
}

