/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*-------------------------- ------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
*/

/*-------------------------- ------------------------------------
  BufDeleteRec(int recnum):
  Deletes a record from the buffer list.

  Return:
    If recnum is greater or less than the num of record FALSE is returned.

  Entry Requirements:
    int recnum - number of record to delete. 

  Development History:
    Began: 09/17/93 - Gilbert Hyatt.
    Edited:04/14/94 - Gilbert Hyatt 
      Now uses pipec.h as entry point into the library.
  ---------------------------------------------------------------*/

#include "pipec.h"

int 
BufDeleteRec (int rec_num)
{

  extern BUFFER_HEAD  _Rbuffer;
  extern char         *Rbuffer;
  int    index;
  RECPTR *ptr1, *ptr2, *oldlastnext;

  if (rec_num > _Rbuffer.nbufs)         return(FALSE);
  if (rec_num < 1)                      return(FALSE);
  if (_Rbuffer.first == _Rbuffer.end)   return(FALSE);

  ptr1 = BufGetRecPtrOf((rec_num -1));
  ptr2 = ptr1->next;
  if (rec_num == _Rbuffer.nrecs) _Rbuffer.last  = ptr1;
  if (rec_num == _Rbuffer.nbufs) _Rbuffer.end   = ptr1;
  if (rec_num == 1)              _Rbuffer.first = _Rbuffer.first->next;
  ptr1->next = ptr2->next;
  _Rbuffer.nrecs--;

  if (_Rbuffer.num_fixed == TRUE) {
    oldlastnext = _Rbuffer.last->next;
    _Rbuffer.last->next = ptr2;
    ptr2->next = oldlastnext;
    ptr2->vmrecnum  = BufNotInUses;
  } else {
    _Rbuffer.nbufs--;
    if (ptr2->vmrecnum == BufRealMem) {free(ptr2->data); _Rbuffer.data_space_used -= _Rbuffer.recl;}
    free(ptr2);
  }  /* end of if-else */
  _Rbuffer.end->next = _Rbuffer.first;

  if (_Rbuffer.nrecs == 0) {
    _Rbuffer.first        = _Rbuffer.end;
    _Rbuffer.last         = _Rbuffer.end;
    _Rbuffer.current      = _Rbuffer.end;
    _Rbuffer.last_request = _Rbuffer.end;
    return(TRUE);
  }  /* end of if */

  if (_Rbuffer.current      == ptr2)    Rbuffer                = _Rbuffer.working->data;
  if (_Rbuffer.current      == ptr2)    _Rbuffer.current       = _Rbuffer.end;
  if (_Rbuffer.current      == ptr2)    _Rbuffer.num_current   = BufNoValue;
  if (rec_num < _Rbuffer.num_current)   _Rbuffer.num_current--;
  
  if (_Rbuffer.last_request == ptr2)    _Rbuffer.last_request  = _Rbuffer.end;
  if (_Rbuffer.current      == ptr2)    _Rbuffer.num_last_req  = BufNoValue;
  if (rec_num < _Rbuffer.num_last_req)  _Rbuffer.num_last_req--;

  if (_Rbuffer.lastVMrec    == ptr2)    _Rbuffer.lastVMrec     = _Rbuffer.end;
  if (_Rbuffer.lastVMrec    == ptr2)    _Rbuffer.num_lastVMrec = BufNoValue;
  if (rec_num < _Rbuffer.num_lastVMrec) _Rbuffer.num_lastVMrec--;

  return(TRUE);
}  /* end of BufDeleteRec.c() */







