/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*-------------------------- ------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
*/
/*---------------------------------------------------------------
  BufDestroyRecs() -
    Delete all record from the buffer list, if buffer size is 
    fixed the buffer size is set to 0.

  Return:
    Always returns TRUE.

  Entry Requirements:
    None.
 
  Development History:
    Began: 09/17/93 - Gilbert Hyatt.
    Edited:04/14/94 - Gilbert Hyatt 
      Now uses pipec.h as entry point into the library.
   ---------------------------------------------------------------*/

#include "pipec.h"

int 
BufDestroyRecs (void)
{
  extern BUFFER_HEAD  _Rbuffer;

  if (_Rbuffer.num_fixed)
    BufFixSizeTo(0);
  else 
    BufDeleteRecs(1, _Rbuffer.nrecs);
    
  return(TRUE);
}  /* end of BufEmptyRecs() */
