/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*-------------------------- ------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
*/
/*---------------------------------------------------------------
  BufGetRecPtrOf(int recnum)

  Return:
   a RECPTR*, this is an enternal data struct that can be used by
   other enternal functions.

  Entry Requirements:
    int recnum: the number of the record, you wish the RECPTR* for.
 
  Development History:
    Began: 09/17/93 - Gilbert Hyatt.
    Edited:04/14/94 - Gilbert Hyatt 
      Now uses pipec.h as entry point into the library.
  ---------------------------------------------------------------*/

#include "pipec.h"

RECPTR *
BufGetRecPtrOf (int recnum)
{
  static RECPTR       *ptr;      
  static int          index;
  static int          START;
  extern BUFFER_HEAD  _Rbuffer;

  if (recnum  < 1)              return(_Rbuffer.end);
  if (recnum == 1)              return(_Rbuffer.first);
  if (recnum >= _Rbuffer.nrecs) return(_Rbuffer.last);

  ptr   = _Rbuffer.first;
  START = 1;

  START = (_Rbuffer.num_current < recnum && _Rbuffer.num_current > 0)?_Rbuffer.num_current:START;
  ptr   = (_Rbuffer.num_current < recnum && _Rbuffer.num_current > 0)?_Rbuffer.current:ptr;
  
  START = (_Rbuffer.num_last_req < recnum && _Rbuffer.num_last_req > START)?_Rbuffer.num_last_req:START;
  ptr   = (_Rbuffer.num_last_req < recnum && _Rbuffer.num_last_req > START)?_Rbuffer.last_request:ptr;
  
  START = (_Rbuffer.num_lastVMrec < recnum && _Rbuffer.num_lastVMrec > START)?_Rbuffer.num_lastVMrec:START;
  ptr   = (_Rbuffer.num_lastVMrec < recnum && _Rbuffer.num_lastVMrec > START)?_Rbuffer.lastVMrec:ptr;

  for(index = START; index < recnum; index++) ptr = ptr->next;

  return(ptr);
}  /* end of BufGetRecPtrOf() */



