/*---------------------------------------------------------------*/
/*   Copyright (c) 1994 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*-------------------------- ------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
*/

/*--- BufNextRec -----------------------------------------------
  BufNextRec():
    Advance one record down the buffer list.
 
  Return:
    FALSE: if at end of list.
    TRUE:  
 
  Entry Requirements:
    None.

  Development History:
    Began: 02/17/93 - Gilbert Hyatt.
    Edited:04/14/94 - Gilbert Hyatt 
      Now uses pipec.h as entry point into the library.
  --------------------------------------------------------------*/

#include "pipec.h"

int 
BufNextRec (void)
{
  extern BUFFER_HEAD  _Rbuffer;
  extern char         *Rbuffer;
  RECPTR              *ptr;

  if(_Rbuffer.current == _Rbuffer.end) 	       return(FALSE);
  if(_Rbuffer.current->next == _Rbuffer.first) return(FALSE);

  ptr                   = _Rbuffer.current;
  ptr                   = ptr->next;
  Rbuffer               = BufMapData(ptr);

  _Rbuffer.last_request = _Rbuffer.current;
  if(_Rbuffer.num_current >0) _Rbuffer.num_last_req =_Rbuffer.num_current;

  _Rbuffer.current      = ptr;
  if(_Rbuffer.num_current >0)_Rbuffer.num_current  =_Rbuffer.num_current+1;
  
  return(TRUE);
}  /* end of BufUseRec() */

