/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*-------------------------- ------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
*/

/*--- BufShiftIn -----------------------------------------------
  BufShiftIn(int numPts)                    
    Get the numPts number of records from the flow and buffer them
    in the buffer list.
  
  Return:
    Number of records buffered.
 
  Entry Requirements:
    int numPts.
 
  Development History:
    Began: 09/17/93 - Gilbert Hyatt.
    Edited:04/14/94 - Gilbert Hyatt 
      Now uses pipec.h as entry point into the library.
  ---------------------------------------------------------------*/

#include "pipec.h"

int 
BufShiftIn (int numPts)
{
  int index =0;
 
  if(numPts >0)
    for(index =0; index < numPts; index++) {
      if(rdata() >0) BufStoreRec();
      else           return(index);
    }
  else
    while(rdata() >0) {
      index++;
      BufStoreRec();
    }
  
 return(index);
}  /* end of BufShiftIn.c */
 
