/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
 */

/*--BUFFGETCOLVAL ----------------------
 Gets the requested column value from
 the given character buffer.

 returns 0 if the column is not found.
 this is not to be considered an
 error status since zero is also a
 valid return.

 Entry requirements:
   RECBUFF: The buffer containing the
            record to operate on.

    COLNAME: The short column name for
             which its value is to be
             returned.

 Development History:
   Begun: 5/7/87 - Marco Zagha
     (This used to be the body of
      the getcolval function which
      was developed by Todd King on
      2/21/86).
       Under GG44 support.
    Edited:04/14/94 - Gilbert Hyatt
    Now uses pipec.h as entry point
    into the library.

---------------------------------------*/

#include "pipec.h"

double 
buffgetcolval (char *recbuff, char *colname)
{
  int i,dnum;
  double retval;

  union pair
    {  int ival;
       float fval;
       double dval;
       char text[sizeof(double)];
    } pairs;

  extern DESC Desc[];

  dnum=colnum(colname);
  dnum--;					/* Adjust count */
  if(dnum < 0) return(0);			/* Not found */
  if(Desc[dnum].type == 'A') return(0);         /* Can't do characters */
  for(i=0;i<Desc[dnum].width;i++) pairs.text[i]=recbuff[Desc[dnum].start+i];
  switch(Desc[dnum].type)
  {
    case 'I':
	      retval=pairs.ival;
	      break;
    case 'R':
	      retval=pairs.fval;
	      break;
    case 'T':
    case 'D':
	      retval=pairs.dval;
	      break;
  }
  return(retval);
}

