/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
 */

/*-- GETREC --------------------------------------
 Places a record into the current record work
 area. The record is taken from the internal
 record block. If nothing is available in the
 block or the block is exhausted a new block is
 read. Returns the number of bytes in the
 record if a record is available, 0 if End Of
 File and -1 if an error has occured.

  Entry Requirements:
      NONE

  Developement History:
    Begun: 11/4/86  - Todd King
            Under GH06 support.
    Modified: 7/20/88 - Todd King
       To bring in line with new structures for
       blocks.
      Under GH06 support.
    Modified: 01/25/94 - Gilbert Hyatt
       Chaned bcopy() to memmove()
    Edited:04/14/94 - Gilbert Hyatt
      Now uses pipec.h as entry point
      into the library.
------------------------------------------------*/

#include "pipec.h"

int 
getrec (void)
{
  extern BLOCK In;
  extern int Recl;
  int nread;

  extern char         *Rbuffer;
  extern BUFFER_HEAD  _Rbuffer;

  Rbuffer               = _Rbuffer.working->data;
  _Rbuffer.last_request = _Rbuffer.current;
  _Rbuffer.current      = _Rbuffer.working;

  if(In.offset + Recl > In.guage)	/* If block exhuasted */
  {
    In.offset=0;		/* Reset */
    In.guage=0;		/* Reset */
    if(In.full == 0) In.full=(BLKSIZE/Recl)*Recl; /* If 1st time, det fullmark*/
    while((nread=read(datain, In.block+In.guage, In.full-In.guage)) > 0)
    {
      In.guage+=nread;
      if(In.guage == In.full) break;
    }
    if(nread <= 0 && In.guage == 0) { In.guage = -1; return(nread); }
  }
  memcpy(Rbuffer, In.block+In.offset,  Recl);  /* Move record into work area */
  In.offset+=Recl;
  return(Recl);
}



