/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
 */

/*-- PLOG ----------------------------------
 Entry Requirements:
   STRING: String to print
   TYPE: A character representing the type
        of message ('R','I', 'E')

 Developement History:
    Begun: 2/6/87 - Marco Zagha
            Under GG44 support.
  Edited:04/14/94 - Gilbert Hyatt
    Now uses pipec.h as entry point
    into the library.
------------------------------------------*/

#include <sys/types.h>
#include <fcntl.h> 
#include "pipec.h"

int 
plog (char string[], int type)
{
  int ret;
  char *nl="\n";
  char tempstr[20];

  fcntl(errlog, F_SETLKW, F_WRLCK);   /* Obtain an exclusive lock */
  /* flock(errlog,LOCK_EX); */        /* Old                      */
  pdbMessageID++;
  sprintf(tempstr, "%c %d line %d: ", type, pdbMessageID, pdbFittingID);
  write(errlog, tempstr, strlen(tempstr));
  ret=write(errlog,string,strlen(string));
  write(errlog,nl,strlen(nl));
  fcntl(errlog, F_UNLCK, F_WRLCK);    /* Unlock file */
  /* flock(errlog,LOCK_UN); */        /* Old         */
  if(ret > 0) ret=1;
  return(ret);
}
