/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
 */

/*-- SETCOLSTR ------------------------
 Sets a column to the given string.
 returns -1 if the string could not
 set for whatever reason; otherwise
 0.

 Entry Requirements:
   COLNAME: The short column of the
            for which the string
            value is to be set
   STRING: The value to set the
           column to.

 Development History:
   Begun: 2/21/86 - Todd King
            Under GH06 support.
   Update: 9/5/86 - Marco Zagha
            Under GG44 support.
   Edited:04/14/94 - Gilbert Hyatt
     Now uses pipec.h as entry point
     into the library.
------------------------------------*/

#include "pipec.h"

int 
setcolstr (char colname[], char string[])
{
  extern DESC Desc[];
  extern char *Rbuffer;

  int descno, last, begin, temp, i;

  descno = excolnum(colname);
  descno--;

  if (Desc[descno].type != 'A') return (-1); /* Not valid column type */

  last = Desc[descno].width;
  begin = Desc[descno].start;
  temp = strlen(string);
  if (temp > last) temp = last;
  for (i=0; i<temp; i++) Rbuffer[begin+i] = string[i];
  for (i=temp; i<last; i++) Rbuffer[begin+i] = ' ';
  return (0);
}

