/*---------------------------------------------------------------*/
/*   Copyright (c) 1990 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
*/

/*-- dfs_use_buffer_record ---------------------------------------------
   Makes a specific record in a record buffer the current
   working record. After this call values in the record
   can be accessed or altered using any of the DFS calls.

   Entry Requirements:
       buffer: A pointer to a record buffer (created by make_buffer())
       recnum: The number of the record to make the current
	       working record.

   Development History
      Begun: 10/19/90 - Todd King
      Edited:04/14/94 - Gilbert Hyatt
        Now uses pipec.h as entry point into the library.
---------------------------------------------------------------*/

#include "pipec.h"

extern char *Rbuffer;	/* DFS working record */

int 
dfs_use_buffer_record (DFS_RECBUFF *buffer, int recnum)
{
   char *ptr;
   int real_rec;

   if(buffer == NULL) return(FALSE);
   if(recnum < 0 || recnum >= buffer->nrecs) return(FALSE);

   real_rec = buffer->first_rec + recnum;
   if(real_rec >= buffer->max_recs) { 
      real_rec -= buffer->max_recs; 
   }

   ptr = buffer->raw + (buffer->recl * real_rec);
   memcpy(Rbuffer, ptr, buffer->recl);
   buffer->cur_rec = recnum;

   return(TRUE);
}

