/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)funcdefc.h	1.7    (UCLA/IGPP)    28 Jul 1994
 */
/* Declaration of function types  */
/* Written: 9/23/86 - Todd King   */
/* Modified: 6/8/87 - Marco Zagha (pread,pwrite,peof,and perrno defined) */
      
#ifndef _FUNCDEFC_
#define _FUNCDEFC_

#include "buf_list.h"
#include "dfs_buffer.h"

/* BufAdvanceThru.c */
int BufAdvanceThru (int start, int finish);
/* BufIsInListAlready.c */
int BufIsInListAlready (char *columns[]);
/* BufStoreRec.c */
int BufStoreRec (void);
/* BufDeleteRec.c */
int BufDeleteRec (int rec_num);
/* BufMalloc.c */
char *BufMalloc (int size);
int ShiftOutRec (void);
/* BufUnuseRec.c */
int BufUnuseRec (void);
/* BufDeleteRecs.c */
int BufDeleteRecs (int start, int end);
/* BufMapData.c */
char *BufMapData (RECPTR *recptr);
/* BufUseRec.c */
int BufUseRec (int rec_num);
/* BufDestroyRecs.c */
int BufDestroyRecs (void);
/* BufNumOfBufs.c */
int BufNumOfBufs (void);
/* BufVarQSort.c */
int compareQ (RECPTR **entry1, RECPTR **entry2);
int BufVarQSort (char *columns[]);
int BufVarQSortSublist (int start, int stop, char *columns[]);
/* BufFixSizeTo.c */
int BufFixSizeTo (int num_bufs);
/* BufNumOfRecs.c */
int BufNumOfRecs (void);
/* BufVarSorts.c */
int compare (RECPTR *entry1, RECPTR *entry2);
RECPTR *merge (RECPTR *a, RECPTR *b);
RECPTR *mergesort (RECPTR *c);
int BufVarSort (char *columns[]);
int BufVarSortSublist (int start, int stop, char *columns[]);
/* BufGetRecPtrOf.c */
RECPTR *BufGetRecPtrOf (int recnum);
/* BufShiftOut.c */
int BufShiftOut (int num_rec);
/* GetColStr.c */
char *GetColStr (int bufnum, char colname[]);
/* GetColVal.c */
double GetColVal (int bufnum, char *colname);
/* SetColVal.c */
int _SetColVal (int bufnum, char *colname, double value);
/* BufNextRec.c */
int BufNextRec (void);
/* BufShiftIn.c */
int BufShiftIn (int numPts);
/* InDataFlow.c */
int InDataFlow (void);
/* buffgetcolval.c */
double buffgetcolval (char *recbuff, char *colname);
/* buffrec.c */
int buffrec (void);
/* buffsetcolval.c */
int _buffsetcolval (char recbuff[], char colname[], double value);
/* checkflag.c */
int checkflag (unsigned int flag, int col);
/* colnum.c */
int colnum (char colname[]);
/* colsort.c */
int colsort (char colname[]);
/* coltype.c */
int coltype (char colname[]);
/* colunits.c */
char *colunits (char colname[]);
/* colwidth.c */
int colwidth (char colname[]);
/* condesc.c */
int condesc (char string[], int descno);
/* dataend.c */
int dataend (void);
/* descend.c */
int descend (void);
/* errexit.c */
int errorexit (int errnum, int NumErrors, char fitting[], char *error[]);
int insertfiller (char FilledMessage[], char message[], char filler[]);
int fillerrexit (int errnum, int NumErrors, char fitting[], char *error[], char filler[]);
/* excolnum.c */
int excolnum (char colname[]);
/* exists.c */
int exists (char colname[]);
/* flagclear.c */
int flagclear (unsigned int flag, int col);
/* flagrec.c */
int flagrec (void);
/* flagset.c */
int flagset (unsigned int flag, int col);
/* flagtoggle.c */
int flagtoggle (unsigned int flag, int col);
/* getbpline.c */
int getbpline (int argc, char *argv[]);
/* getcmd.c */
int _GetCmdlineOpt (int argc, char *argv[], char *options[], char value[], unsigned p_mesg);
/* getcolstr.c */
char *getcolstr (char colname[]);
/* getcolval.c */
double getcolval (char colname[]);
/* getrec.c */
int getrec (void);
/* ignoreinput.c */
int ignoreinput (void);
/* inbuff.c */
int inbuff (void);
/* initpipe.c */
int _InitPipe (int argc, char *argv[]);
/* isflag.c */
int isflag (char colname[]);
/* lcolname.c */
char *lcolname (char colname[]);
/* makedesc.c */
int makedesc (char longc[], char shortc[], char units[], int type, int width, int sort);
/* moredata.c */
int moredata (void);
/* numerictype.c */
int numerictype (int c);
/* passthru.c */
int passthru (void);
/* perrlog.c */
int perrlog (char string[]);
/* plog.c */
int plog (char string[], int type);
/* presult.c */
int presult (char string[]);
/* putrec.c */
int putrec (void);
/* pwarn.c */
int pwarn (char string[]);
/* rbuff.c */
int rbuff (void);
/* rdata.c */
int rdata (void);
/* rdesc.c */
int rdesc (void);
/* reclen.c */
int reclen (void);
/* rmvdesc.c */
int rmvdesc (char colname[]);
/* rrecord.c */
int rrecord (char buffer[]);
/* scolname.c */
char *scolname (int cindex);
/* sendbuff.c */
int sendbuff (void);
/* setbuff.c */
int setbuff (int numrecs);
/* setcolflag.c */
int setcolflag (char colname[]);
/* setcolstr.c */
int setcolstr (char colname[], char string[]);
/* setcolval.c */
int _setcolval (char colname[], double value);
/* setdesc.c */
int setdesc (int at, char longc[], char shortc[], char units[], int sort);
/* setrec.c */
int setrecord (int recnum);
/* shiftbuff.c */
int shiftbuff (int nrecs);
/* srecord.c */
int srecord (char buffer[]);
/* texttype.c */
int texttype (int c);
/* uniqname.c */
char *uniqname (char template[]);
/* validtype.c */
int validtype (int c);
/* wbuff.c */
int wbuff (void);
/* wdata.c */
int wdata (void);
/* wdesc.c */
int wdesc (void);
/* pflush.c */
int pflush (void);
/* fill_buff.c */
int dfs_fill_buffer (DFS_RECBUFF *buffer);
/* flush_buff.c */
int dfs_flush_buffer (DFS_RECBUFF *buffer, int write_out);
/* free_buff.c */
int dfs_free_buffer (DFS_RECBUFF *buffer);
/* nrecs_buff.c */
int dfs_nrecs_buffer (DFS_RECBUFF *buffer);
/* save_buff.c */
int dfs_save_buffer_record (DFS_RECBUFF *buffer);
/* shift_buff.c */
int dfs_shift_buffer (DFS_RECBUFF *buffer, int nrecs, int write_out);
/* use_buff.c */
int dfs_use_buffer_record (DFS_RECBUFF *buffer, int recnum);
/* make_buff.c */
DFS_RECBUFF *dfs_make_buffer (int nrecs);
/* nextrec_buff.c */
int dfs_buffer_nextrec (DFS_RECBUFF *buffer);
/* setrec_buff.c */
int dfs_set_buffer_record (DFS_RECBUFF *buffer, int recnum);
/* store_buff.c */
int dfs_store_buffer_record (DFS_RECBUFF *buffer);
/* FittingName.c */
int setFittingName (char name[]);
char *getFittingName (void);

/*  End of function type declaration  */

/* Beginning of FUNCTION translations */
#define setcolval(a,b)	_setcolval(a, (double)(b))
#define buffsetcolval(a, b, c) _buffsetcolval(a, b, (double)(c))
#define pread		read
#define pwrite		write
#define peof		close
#define perrno()	errno

/* End of function translations */

#endif /* _FUNCDEFC_ */
