/*----------------------------------------------------------------
   Copyright (c) 1992 Regents of the University of California
                 All Rights Reserved

   Decalrations for the message functions.

   Development History:
      Begun: 01/24/92 - Todd King
      Edited:04/14/94 - Gilbert Hyatt
	added function prototypes.

   Version:
      @(#)message.h	1.7    (UCLA/IGPP)   28 Jul 1994
------------------------------------------------------------------*/
#ifndef message_h
#define message_h	1

#include <stdio.h>
#include "list.h"	      /* IGPP list manager */

/* Message severity codes */

#define MM_FATAL	1
#define MM_WARNING	2
#define MM_INFORMATION	3

typedef struct MM_MESSAGE {
   char *message;		/* The text of the message. */
   int id;			/* Identfing ID - must be unique. */
   int severity;		/* The severity code (i.e. MM_FATAL). */
   int exit_code;		/* The exit code if serverity is MM_FATAL. */
} MM_MESSAGE;

/* Message output codes */

#define MM_OUT_FILE	1
#define MM_OUT_FUNCTION	2

extern FILE	*MM_out_file;		/* Defined in set_output.c */
extern int	MM_out_type;		/* Defined in set_output.c */
extern int	(*MM_out_function)();	/* Defined in set_output.c */
extern LIST_NODE	*MM_trace;	/* Defined in trace_push.c */

/* Limits */
#define MM_BUFF_MAX	1024		/* Maximum size of message buffer */

/* function prototyes */

/* pmessage.c */
int mm_pmessage (MM_MESSAGE list[], int id, ...);
/* printf.c */
int mm_printf (FILE *outFile, int severity, char *format, char *text);
/* set_output.c */
int mm_set_output (int type, ...);
/* test.1.c */
int main (int argc, char *argv[]);
int part2 (void);
int part3 (void);
/* trace_pop.c */
int mm_trace_pop (void);
/* trace_push.c */
int mm_trace_push (char text[]);

#endif /* message_h */
