/*---------------------------------------------------------------*/
/*   Copyright (c) 1991 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%   (UCLA/IGPP)   %G%
*/
/*-- ffcol_type -------------------------------------------------------
  Returns the data type for the given field. 

  Entry Requirements:
    ffptr: A pointer to a flatfile.
    idx: The index of the column to bind to.

  Return Value:
   0 : If the field index or the flatfile pointer.
   otherwise: one of the DFS data type codes.

  Development History:
    Begun: 12/12/91 - Todd King
-----------------------------------------------------------------*/
#include "ffio.h"

int 
ffcol_type (FLATFILE *ffptr, unsigned int idx)
{
   FF_FULL_DESC *dptr;

   if(ffptr == NULL) return(0);

   dptr = ffget_desc(ffptr, idx);
   if(dptr == NULL) return(0);

   return(dptr->type);
}
