/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffget_col_val ------------------------------------------------
  Gets the value of a field given its index in the descriptor 
  database maintained as part of the information related to
  a flatfile. All field values are returned as a double. Character
  fields are converted to doubles with a call to atof().

  Entry Requirements:
    ffptr: A pointer to a flatfile.
    idx: The index of the field of interest. Note that indexing
	 begins at 0.

  Return Value:
    The value of the field. If the fields is
    unknown then the value returned is always 0.0.

  Development History:
    Begun: 11/02/89 - Todd King
-----------------------------------------------------------------*/
#include "ffio.h"

double 
ffget_col_val (FLATFILE *ffptr, unsigned long idx)
{
   double atof();

   char *ptr;
   double retval;
   FF_FULL_DESC *desc;

   if(ffptr == NULL) return(0.0);

   if(idx >= ffptr->ncols) return(0.0);

   desc = ffget_desc(ffptr, idx);

   switch(desc->type) {
      case FF_INT:
	ptr = ffptr->rec_buff + desc->offset;
	retval = (* (int *)ptr);
	break;
      case FF_FLOAT:
	ptr = ffptr->rec_buff + desc->offset;
	retval = (* (float *)ptr);
	break;
      case FF_DOUBLE:
	ptr = ffptr->rec_buff + desc->offset;
	retval = (* (double *)ptr);
	break;
      case FF_ALPHA:
	ptr = ffptr->rec_buff + desc->offset;
	retval = atof(ptr);
	break;
      case FF_TIME:
	ptr = ffptr->rec_buff + desc->offset;
	retval = (* (TIME *)ptr);
	break;
  }
  return(retval);
}

