/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
	%W%	(UCLA, IGPP) %G%
 */
#include "ffio.h"
#include "flagdefc.h"
/*-- ffisflag ------------------------------------------------
   Determines whether a value in the current flatfile record is
   a flag or not. 

   Entry Requirements:
     ffptr: A pointer to a flatfile.
     idx: THe index of the column to check.

   Return Value:
    1 if it is and 0 if not. 
    If ffptr or idx is not valid -1 is returned

   Development History:
     Begun: 4/90 - Todd King
--------------------------------------------------------------*/
int 
ffisflag (FLATFILE *ffptr, int idx)
{

#define ERRORMARGIN	1.0e+35   /* due to roundoff errors of floats */

  int retval;
  int j;
  double val;
  char tempstr[FF_MAX_FIELD_WIDTH + 1];
  FF_FULL_DESC *desc;

  if(ffptr == NULL) return(-1);
 
  if(idx >= ffptr->ncols || idx < 0) return(-1);

  desc = ffget_desc(ffptr, idx);
  switch(desc->type)
  {
    case FF_INT:
	      val = ffget_col_val(ffptr, idx);
	      retval = (((int) val >= FLAGINT) || isnan(val) || isinf(val));
	      break;
    case FF_FLOAT:
	      val = ffget_col_val(ffptr, idx);
	      retval = (((float) val >= (FLAGREAL-ERRORMARGIN)) ||
			isnan(val) || isinf(val));
	      break;
    case FF_DOUBLE:
    case FF_TIME:
	      val = ffget_col_val(ffptr, idx);
	      retval = ((val >= FLAGDOUBLE) || isnan(val) || isinf(val));
	      break;
    case FF_ALPHA: 
	      strcpy(tempstr, ffget_col_str(ffptr, idx));
	      if (tempstr[0] != '?')
		retval = 0;
	      else    /* flag if all chars after '?' are spaces */
	        for (j = 1, retval = 1; tempstr[j] != '\0' && retval; j++)
		  if (tempstr[j] != ' ') retval = 0;
	      break;
  }
  return (retval);
}
