/*-----------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California    */
/*                 All Rights Reserved                             */
/*-----------------------------------------------------------------*/
/*      %W%   (UCLA/IGPP)   %G%                                    */
/*--ffmakedesc  -------------------------------------------------- */
/* Makes a new descriptor in the data base at the next available   */
/* location. Width can only be set for 'A' types For the other     */
/* types system sizes are taken. Returns -1 if impossible to do    */
/* what was requested, the current number of descriptors otherwise */
/*                                                                 */
/* Entry Requirements:                                             */
/*      ffptr: A flatfile poionter                                 */
/*   longname: The long column name to use.                        */
/*  shortname: The short column name to use.                       */
/*      units: The units label to use.                             */
/*       type: The data type of the column  (i.e. A, D, I, R, T)   */
/*      width: The width of the column in bytes.                   */
/*       sort: The sort order of the column.                       */
/*                                                                 */
/*   Return Values:                                                */
/*    FF_FAILURE: If successful                                    */
/*    FF_SUCCESS: If Finals                                        */
/*                                                                 */
/*   Developement History:                                         */
/*     Began: ??/??/9? - Gilbert Hyatt                             */
/*                                                                 */
/*-----------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include "ffio.h"
#include "maxpipec.h"

int 
ffmakedesc (FLATFILE *ffptr, char longname[FF_LNAME + 1], char shortname[FF_SNAME + 1], char units[FF_UNITS + 1], int type, unsigned int width, int sort)
{
  FF_DESC FF_LOC_DESC[3];

  if (ffptr->ncols >= MAXCOLS) return(FF_FAILURE);
  
  strncpy(FF_LOC_DESC[0].longname,  longname,  FF_LNAME);
  strncpy(FF_LOC_DESC[0].shortname, shortname, FF_SNAME);
  strncpy(FF_LOC_DESC[0].units,     units,     FF_UNITS);
          FF_LOC_DESC[0].type       = type;
          FF_LOC_DESC[0].width      = width;
          FF_LOC_DESC[0].sort       = sort;

  strcpy(FF_LOC_DESC[1].longname,  "");
  strcpy(FF_LOC_DESC[1].shortname, "");
  strcpy(FF_LOC_DESC[1].units,     "");
         FF_LOC_DESC[1].type        = ' ';
         FF_LOC_DESC[1].width       = 0;
         FF_LOC_DESC[1].sort        = 0;

  if (ffadd_desc(ffptr, FF_LOC_DESC) == FF_FAILURE)
    return(FF_FAILURE);

  return(FF_SUCCESS);
}  /* end of ffmakedesc() */


