/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffpad_str ----------------------------------------------------
 Pads the given string to the specified length with a specific
 character.
 NOTE: There is a similar call (called pad_str) in the parser library.
       So that the ffio library does not depend on any others this call
       is included in the ffio library even though it might also exist
       else where.

  Entry Requirements:
    str: The string to pad.
    pchar: The pad character.
    to: The number of characters to pad to.

  Return Value:
    nothing


  Development History:
    Begun: 11/13/89 - Todd King
-----------------------------------------------------------------*/
int 
ffpad_str (char str[], int pchar, int to)
{
   int i;

   for(i = strlen(str); i < to; i++) {
     str[i] = pchar;
   }
}


