/*---------------------------------------------------------------*/
/*   Copyright (c) 1994 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%   (UCLA/IGPP)   %G%
*/
/*** VarStrDup.c *************************************************/
/* Takes in a variable list of strings, terminated by a NULL, and*/
/* returns a concatinated list.  The space for the concatination */
/* is malloced out, with strdup.                                 */
/*                                                               */
/* Input:                                                        */
/*   Value list of char*, last item must be NULL                 */
/*                                                               */
/* Return:                                                       */
/*   char* : concatinated string of the inputs.  Returns NULL on */
/*           failure.                                            */
/*                                                               */
/* Example:                                                      */
/*   char* sptr = VarStrDup("The ", "cat", " ", "the hat", NULL);*/
/*                                                               */
/*  Developement History:                                        */
/*    Begun: 03/16/94 - Gilbert F. Hyatt                         */
/*                                                               */
/*****************************************************************/
#include <string.h>
#include <stdarg.h>	

char*
VarStrDup(char* start, ...)
{
  char    results[4096];
  char    *ptr;
  int     length;
  va_list ap;

  if(start == (char*)0) return(NULL); 

  strcpy(results, start);
  length = strlen(start);

  va_start(ap, start);
  while((ptr = va_arg(ap, char *)) != NULL) {
    if((length += strlen(ptr)) > sizeof(results)) return(NULL);
    strcat(results, ptr);
  }
  va_end(ap);

  return strdup(results);
}


/*** VarStrCat.c *************************************************/
/* Takes in a variable list of strings, terminated by a NULL, and*/
/* returns a concatinated list.  The space for the concatination */
/* is malloced out, with strdup.                                 */
/*                                                               */
/* Input:                                                        */
/*   Value list of char*, last item must be NULL                 */
/*                                                               */
/* Return:                                                       */
/*   char* : concatinated string of the inputs.  Returns NULL on */
/*           failure.                                            */
/*                                                               */
/* Example:                                                      */
/*   char results[100];                                          */
/*   VarStrCpy(results, "The cat", " ", "in the hat", NULL);     */
/*                                                               */
/*                                                               */
/*  Developement History:                                        */
/*    Begun: 03/16/94 - Gilbert F. Hyatt                         */
/*                                                               */
/*****************************************************************/
char*
VarStrCpy(char* results, ...)
{
  char    *ptr;
  int     length;
  va_list ap;
 
  length = 0;

  strcpy(results, "");

  va_start(ap, results);
  while((ptr = va_arg(ap, char *)) != NULL)  strcat(results, ptr);
  va_end(ap);
 
  return results;
}

