/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%   (UCLA/IGPP)   %G%
 */
#include <stdio.h>
#include "specialc.h"
#include "lowmask.h"

/*-- DIR ----------------------------------------------------------*/
/* Finds all the files in the specified directory which match the  */
/* the given mask. The listing may be sorted by an algorythm       */
/* defined by a passed routine. Will not exceed DIRMAXFILES number */
/* of files.                                                       */
/*                                                                 */
/* Returns:                                                        */
/*   -3: If no files are found ... may be due to bad path or ?     */
/*   -2: if it runs out of memory while trying to store entry      */
/*   -1: If there's any error (bad mask, et al)                    */
/*  otherwise the count of the number of entries in the list.      */
/*                                                                 */
/*  Entry Requirements:                                            */
/*    path: the path of the directory to read the files.           */
/*    dirlist: the array of strings to place the valid file names  */
/*    mask: the file mask to use.                                  */
/*    sorter: pointer to a sorting function. If NULL no sorting is */
/*            is done. Must match requirement as specified for     */
/*            'qsort'.                                             */
/*                                                                 */
/*  NOTE: Since the storage space for the entries that are placed  */
/*        in the 'dirlist' variable are dynamically allocated      */
/*        This should be 'free'ed after use by the user.           */
/*        DIRMAXFILES is defined in 'specialc.h'                   */
/*                                                                 */
/*  Developement History:                                          */
/*    Begun: 01/28/87 - Todd King                                  */
/*                   Under GG44 support                            */
/*-----------------------------------------------------------------*/
int 
dir (char pathmask[], char *dirlist[], int (*sorter)())
{
/* return values */
  int no_files	= -3;
  int no_memory	= -2;
  int bad_mask	= -1;

  char *malloc();
  char entry[256];
  int cnt = 0;

/* Set mask for entries and open directory */

  if(setmask(pathmask) != 0) return(bad_mask);

  while(matchfile(entry, D_SHORT) == 0)
  {
    if((dirlist[cnt] = malloc(strlen(entry)+1)) == NULL) return(no_memory);
    strcpy(dirlist[cnt], entry);
    cnt++;
    if(cnt == DIRMAXFILES) break;
  }

  if(cnt == 0) return(no_files);

/* Perform sort if requested */

  if(sorter != NULL) qsort((char *)dirlist, cnt, sizeof(char *), sorter);
  return(cnt);
}

