/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%   (UCLA/IGPP)   %G%
 */

/* -- EDITOR ----------------------------------------------- */
/* Get's the user's editor from his environment.  If the     */
/* environment variable EDITOR is not defined, the path to   */
/* the vi editor is returned.                                */
/*                                                           */
/* ENTRY REQUIREMENTS:                                       */
/*   EDITOR_NAME:  String passed in to receive the value of  */
/*                 the user's editor.                        */
/*                                                           */
/* RETURN VALUES:                                            */
/*   1 if EDITOR was defined; 0 if it was not defined and    */
/*   the default (vi) was used.                              */
/*                                                           */
/*      Development History:                                 */
/*              Begun:  3/4/87 - Marco Zagha                 */
/*                   Under GG44 support                      */
/* --------------------------------------------------------- */
int 
find_editor (char *editor_name)
{
#include <stdio.h>
char *editor;
char *getenv();

editor = getenv("EDITOR");
if (editor == NULL)
  {
    strcpy(editor_name, "/usr/ucb/vi");
    return (0);
  }
else 
  {
    strcpy(editor_name, editor);
    return (1);
  }
}
