/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-- KeywordMatch ------------------------------------------------
 Searches a list of possible key words  
 to see if a given word matches any of  
 them. The list of possible keywords must
 be terminated by a NULL pointer.

 Entry Requirements:
    word : The word to compare to each word in "possible".
    possible : The list of keywords to search.

 Return Values:
    index : The index of a matching keyword if the given 
	    word is a unique fraction of any keyword.
    -1    : If the word is not found.
    -2    : If the word is ambiguous.
                                        
 Development History:                   
   Begun: 11/25/85 - Todd King          
          Under GH06 support.           
                                        
  Version:                              
     %W%      (UCLA/IGPP)     %G%
--------------------------------------------------------------------*/
#ifdef vax
#include <stdio.h>	/* For NULL */
#else
#include <unistd.h>	/* For NULL */
#endif

int 
KeywordMatch (char word[], char *possible[])
{
  int j;
  int match;
  int end;
  char **ptr;
 
  end = strlen(word);  /* Presets */
  match = (-1);
  for(ptr = possible, j = 0; *ptr != NULL && match != -2; ptr++, j++) {
    if(strncmp(word, *ptr, end) == 0) {	/* A match */
       if(match != -1) { /* Ambiguous */
	  match = -2;
	  break;
       } else {
	  match = j;
       }
    }  
  }
  return(match);
}

