/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/* -- ISMATCH ---------------------------------------------- */
/* ENTRY REQUIREMENTS:                                       */
/*   S: A string                                             */
/*   P: A pattern containing combinations of '*' , '?' and   */
/*      [a-z] style character classes (like csh).            */  
/*                                                           */
/* RETURN VALUES:                                            */
/*   True if P matches S.                                    */
/*                                                           */
/*      Development History:                                 */
/*              Begun:  2/8/88 - Marco Zagha                 */  
/*          Under GY49 support.                              */
/*                                                           */
/*  Version:                                                 */
/*     %W%      (UCLA/IGPP)     %G%                          */
/*                                                           */
/*  Note:  this function is in both the parserc and parserf  */
/*         libraries.  If any changes are made, make sure    */
/*         they are duplicated.                              */
/* --------------------------------------------------------- */
#define TRUE	1
#define FALSE	0

int 
ismatch (char *string, char *pattern)
{
  int got_low, found_match;
  char high_char, low_char;
  
  while (*pattern != '\0') {
    switch (*pattern) {
      case '?': /* matches any single character except '\0' */
	if (*string == '\0') {
	  return(FALSE);
	} else {
          string++;
	  pattern++;
	}
	break;
      case '*': /* matches zero or more characters */
	pattern++;
	if (*pattern == '\0')
	  return(TRUE);  /* "*\0" matches anything */
	while (*string != '\0') {
	  if (ismatch(string, pattern))
	    return(TRUE);
	  string++;
	}
	return(FALSE);
	break;
      case '[': /* a character class */
	pattern++;
	got_low = FALSE;
	found_match = FALSE;
	while (*pattern != '\0') {
	  if (*pattern == ']') { /* end of range */
	    if (!found_match) {
	      return(FALSE);
	    } else {
	      break;
	    }
	  } else if (*pattern == '-') { /* a range */
	    if (!got_low) {
	      return(FALSE);
	    }
	    pattern++;
	    if ((high_char = *pattern) == '\0') {
	      return(FALSE);
	    }
	    if ((low_char <= *string) && (*string <= high_char)) {
	      found_match = TRUE;
	    }
	    got_low = FALSE;
	    pattern++;
	  } else { /* plain character or first character of a range */
	    if (*pattern == *string) {
	      found_match = TRUE;
	    }
	    got_low = TRUE;
	    low_char = *pattern;
	    pattern++;
	  }
	}
	if (found_match) {
	  pattern++;
	  string++;
	} else {
	  return(FALSE);
	}
	break;
      default: /* an everyday, run-of-the-mill character */
	if (*string != *pattern) {
	  return(FALSE);
	} else {
	  string++;
	  pattern++;
	}
	break;
    }
  }
  if (*string == '\0') 
    return(TRUE);
  else
    return(FALSE);
}
