/*---------------------------------------------------------------*/ 
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/

#include "timec.h"

/*-- maxdaymon ---------------------------------------------------
 Returns the number of days in a month given the index of the
 month and the year.

 Entry Requirements:
    mon: The index of the month (1 = January, 12 = December)
    yr: The full year specification. e.g 1987.

  Return Value:
    The number of days in the month.

   Version:
       %W%    (UCLA/IGPP)   %G%
----------------------------------------------------------------*/
int 
maxdaymon (
    int mon,			/* Jan = 1, Feb = 2, etc */
    int yr				/* Full year A.D., e.g., 1987 */
) 
{
  int i;

  i = daymon[mon-1];
  if((mon == 2) && !(yr & 0x3) && (yr != 2000)) i++; /* chk leap yr & february */
  return(i);
}  

