/*---------------------------------------------------------------*/ 
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/

#include "timec.h"

/*-- monthday -------------------------------------------------
 Determines the month and day of month for a given day of
 year in a specific year.

 Entry Requirements:
   yr: The base year.
   doy: The day of year.
   month: Assigned the month the day of year falls in.
   day: Assigned the day of the month for the day of year.

  Return Values:
    Undefined.

   Version:
       %W%    (UCLA/IGPP)   %G%
-------------------------------------------------------------*/
int 
monthday (int yr, int doy, int *month, int *day)
{
  int mon = 0;
  int dom;

  int maxdaymon();

  while(doy > 0)
  {
    dom = doy;
    mon++;
    doy -= maxdaymon(mon, yr);
  }

  *month = mon;
  *day = dom;

  return;
}

