/*---------------------------------------------------------------*/ 
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/

#include "timec.h"

/*-- sectime -----------------------------------------------------------
  Calcualtes the number of seconds since the beginning of Jan 1, in
  the reference year (current 1966).

  Entry Requirements:
    yr: The year.
    mon: The month.
    day: The day of the month.
    hr: Hours (24 hour clock).
    min: The minutes of the hour.
    sec: The secondds of the hour.

  Return Value:
    The number of seconds from the Jan. 1 of the reference year (1966).

  Edited: 02/24/94 - Gilbert Hyatt
    Name was changed from stime to sectime for OS compility reasons.

   Version:
       %W%    (UCLA/IGPP)   %G%
-----------------------------------------------------------------------*/
double 
sectime (int yr, int mon, int day, int hr, int min, double sec)
{
  double ttime;
  int i,itime;
  itime = 0;
  if((yr < 100) && (yr > 0))
    yr += 1900;
  for(i=REFYR; i<yr; i++) {	/* <= Change this year for other start times */
    itime += 365;
    if(i%4 == 0) itime += 1;
  }
  itime += doy(yr,mon,day) - 1;
  ttime = itime;
  ttime *= 8.64e4;
  ttime += hr*3.6e3 + min*60.0 + sec; 
  return(ttime);
}

