/*---------------------------------------------------------------*/
/*   Copyright (c) 1991 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%   (UCLA/IGPP)   %G%
*/
/*-- ffcreate -------------------------------------------------------
  Creates a flatfile.

  Entry Requirements:
    name: The name for the flatfile.
    desc : An array of descriptors which describe the structure of
           the flatfile.
    abs : An array of strings which will be placed in the abstract.
    make_path : TRUE or FALSE. Indicates whether the path to the flatfile
                should be created if it does not exist.
    overwrite : TRUE or FALSE. Indicates whether the flatfile should
                be overwritten if a flatfile with the given name
                already exists.

  Return Value:
   0 : If unable to create the path
   1 : If the path was successfully created or already existed.

  Development History:
    Begun: 01/16/92 - Todd King
-----------------------------------------------------------------*/
#include <string.h>	/* for strrchr() */
#include "ffio.h"

FLATFILE *
ffcreate (char name[], FF_DESC *desc, char *abs[], int make_path, int overwrite)
{
   FLATFILE *ffptr;
   char *ptr;

   if(desc == NULL) return(NULL);

   if(!overwrite && ffexists(name)) {
      return(NULL);
   }   

   if(make_path) {
      if((ptr = strrchr(name, '/')) != NULL) {
         *ptr = '\0';
         ffmake_path(name);
         *ptr = '/';
      }
   }

   ffptr = ffopen(name, "w");
   if(ffptr != NULL) {
      ffadd_desc(ffptr, desc);
      ffwrite_desc(ffptr);
      if(abs != NULL) ffwrite_abs(ffptr, abs);
   }

   return(ffptr);
}
