/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffset_col_str ------------------------------------------------
  Sets the contents of a field given its index in the descriptor 
  database maintained as part of the information related to
  a flatfile. The passed string is converted to a number of
  numeric type columns and used directly for character type columns.

  Entry Requirements:
    ffptr: A pointer to a flatfile.
    idx: The index of the field of interest. Note that indexing
	 begins at 0.
    svalue: A string containing the value to set the column to.

  Returns:
    FF_FAILURE if the field index or flatfile pointer is invalid.
    FF_SUCCESS otherwise

  Development History:
    Begun: 11/13/89 - Todd King
-----------------------------------------------------------------*/
#include "ffio.h"

int 
ffset_col_str (FLATFILE *ffptr, unsigned long idx, char svalue[])
{
   double atof();

   static char temp_str[FF_MAX_FIELD_WIDTH + 1];
   char *ptr;
   double dval;
   FF_FULL_DESC *desc;

   if(ffptr == NULL) return(FF_FAILURE);

   if(idx >= ffptr->ncols) return(FF_FAILURE);

   desc = ffget_desc(ffptr, idx);

   switch(desc->type) {
      case FF_INT:
      case FF_FLOAT:
      case FF_DOUBLE:
      case FF_TIME:
	dval = atof(svalue);
	return(ffset_col_val(ffptr, idx, dval));
	break;
      case FF_ALPHA:
	ptr = ffptr->rec_buff + desc->offset;
	strncpy(temp_str, svalue, desc->width);
        temp_str[desc->width] = '\0';
	ffpad_str(temp_str, ' ', desc->width);
	strncpy(ptr, temp_str, desc->width);
	break;
  }
  return(FF_SUCCESS);
}


