/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffwrite_desc ------------------------------------------
  Writes a descriptor to a pre-opened file. The descriptor
  information is extracted from the internal descriptor data
  bases which is maintained within the flatfile information 
  referenced by a flatfile pointer.

  Entry Requirements:
    ffptr: A flat file pointer (as returned from ffopen() )

  Return Value:
    FF_SUCCESS if the write was successful
    FF_FAILURE if the flatfile pointer is invalid.

  Development History:
     Begun: 7/28/89 - Todd King
     modified significantly: 11/15/89 - Todd King
------------------------------------------------------------*/
#include "ffio.h"

int 
ffwrite_desc (FLATFILE *ffptr)
{
   int i = 0;
   FF_FULL_DESC *desc_ptr;

   if(ffptr == NULL) return(FF_FAILURE);

   desc_ptr = ffptr->descdb;
   while(desc_ptr != NULL) {
        fprintf(ffptr->desc, "%-32s%-8s%-16s%c%-3d%2d\n",
           desc_ptr->longname,
           desc_ptr->shortname,
           desc_ptr->units,
           desc_ptr->type,
           desc_ptr->width,
           desc_ptr->sort);
        desc_ptr = desc_ptr->next;
    }
    return(FF_SUCCESS);
}
